#include <a_samp>

#define DIALOG_MDC_PlayerI           9991
#define DIALOG_MDC_PlayerR           9992
#define DIALOG_MDC_VehicleI          9910
#define DIALOG_MDC_VehicleR          9915
#define DIALOG_MDC_UNIFORMS          9995

new PlayerText:MDC[16][MAX_PLAYERS];
new MDCShowing[MAX_PLAYERS];
new String[1000];
new VehicleNames[][] =
{
    "Landstalker", "Bravura", "Buffalo", "Linerunner", "Perrenial", "Sentinel",
    "Dumper", "Firetruck", "Trashmaster", "Stretch", "Manana", "Infernus",
    "Voodoo", "Pony", "Mule", "Cheetah", "Ambulance", "Leviathan", "Moonbeam",
    "Esperanto", "Taxi", "Washington", "Bobcat", "Whoopee", "BF Injection",
    "Hunter", "Premier", "Enforcer", "Securicar", "Banshee", "Predator", "Bus",
    "Rhino", "Barracks", "Hotknife", "Trailer", "Previon", "Coach", "Cabbie",
    "Stallion", "Rumpo", "RC Bandit", "Romero", "Packer", "Monster", "Admiral",
    "Squalo", "Seasparrow", "Pizzaboy", "Tram", "Trailer", "Turismo", "Speeder",
    "Reefer", "Tropic", "Flatbed", "Yankee", "Caddy", "Solair", "Berkley's RC Van",
    "Skimmer", "PCJ-600", "Faggio", "Freeway", "RC Baron", "RC Raider", "Glendale",
    "Oceanic","Sanchez", "Sparrow", "Patriot", "Quad", "Coastguard", "Dinghy",
    "Hermes", "Sabre", "Rustler", "ZR-350", "Walton", "Regina", "Comet", "BMX",
    "Burrito", "Camper", "Marquis", "Baggage", "Dozer", "Maverick", "News Chopper",
    "Rancher", "FBI Rancher", "Virgo", "Greenwood", "Jetmax", "Hotring", "Sandking",
    "Blista Compact", "Police Maverick", "Boxville", "Benson", "Mesa", "RC Goblin",
    "Hotring Racer A", "Hotring Racer B", "Bloodring Banger", "Rancher", "Super GT",
    "Elegant", "Journey", "Bike", "Mountain Bike", "Beagle", "Cropduster", "Stunt",
    "Tanker", "Roadtrain", "Nebula", "Majestic", "Buccaneer", "Shamal", "Hydra",
    "FCR-900", "NRG-500", "HPV1000", "Cement Truck", "Tow Truck", "Fortune",
    "Cadrona", "FBI Truck", "Willard", "Forklift", "Tractor", "Combine", "Feltzer",
    "Remington", "Slamvan", "Blade", "Freight", "Streak", "Vortex", "Vincent",
    "Bullet", "Clover", "Sadler", "Firetruck", "Hustler", "Intruder", "Primo",
    "Cargobob", "Tampa", "Sunrise", "Merit", "Utility", "Nevada", "Yosemite",
    "Windsor", "Monster", "Monster", "Uranus", "Jester", "Sultan", "Stratium",
    "Elegy", "Raindance", "RC Tiger", "Flash", "Tahoma", "Savanna", "Bandito",
    "Freight Flat", "Streak Carriage", "Kart", "Mower", "Dune", "Sweeper",
    "Broadway", "Tornado", "AT-400", "DFT-30", "Huntley", "Stafford", "BF-400",
    "News Van", "Tug", "Trailer", "Emperor", "Wayfarer", "Euros", "Hotdog", "Club",
    "Freight Box", "Trailer", "Andromada", "Dodo", "RC Cam", "Launch", "Police Car",
    "Police Car", "Police Car", "Police Ranger", "Picador", "S.W.A.T", "Alpha",
    "Phoenix", "Glendale", "Sadler", "Luggage", "Luggage", "Stairs", "Boxville",
    "Tiller", "Utility Trailer"
};

public OnFilterScriptInit()
{
	print("\n----------------------------------------");
	print(" MDC System by Rehasher Successfully loaded");
	print("-----------------------------------------\n");
	for(new i = 0; i < MAX_PLAYERS; i++)
	{
		CreatePlayerTextdraws(i);
	}
	return 1;
}

public OnFilterScriptExit()
{
	return 1;
}

public OnPlayerRequestClass(playerid, classid)
{
	return 1;
}

public OnPlayerConnect(playerid)
{
	MDCShowing[playerid] = 0;
	// Creating the textdraws
	CreatePlayerTextdraws(playerid);
	return 1;
}

stock CreatePlayerTextdraws(playerid)
{
	MDC[0][playerid] = CreatePlayerTextDraw(playerid, 135.000000, 121.000000, "                                                    ");
	PlayerTextDrawBackgroundColor(playerid, MDC[0][playerid], 255);
	PlayerTextDrawFont(playerid, MDC[0][playerid], 1);
	PlayerTextDrawLetterSize(playerid, MDC[0][playerid], 0.500000, 29.000000);
	PlayerTextDrawColor(playerid, MDC[0][playerid], -1);
	PlayerTextDrawSetOutline(playerid, MDC[0][playerid], 0);
	PlayerTextDrawSetProportional(playerid, MDC[0][playerid], 1);
	PlayerTextDrawSetShadow(playerid, MDC[0][playerid], 1);
	PlayerTextDrawUseBox(playerid, MDC[0][playerid], 1);
	PlayerTextDrawBoxColor(playerid, MDC[0][playerid], 148);
	PlayerTextDrawTextSize(playerid, MDC[0][playerid], 491.000000, 1.000000);
	PlayerTextDrawSetSelectable(playerid, MDC[0][playerid], 0);

	MDC[1][playerid] = CreatePlayerTextDraw(playerid, 223.000000, 122.000000, "LOS SANTOS POLICE DEPARTMENT");
	PlayerTextDrawBackgroundColor(playerid, MDC[1][playerid], 255);
	PlayerTextDrawFont(playerid, MDC[1][playerid], 2);
	PlayerTextDrawLetterSize(playerid, MDC[1][playerid], 0.280000, 1.699999);
	PlayerTextDrawColor(playerid, MDC[1][playerid], -1);
	PlayerTextDrawSetOutline(playerid, MDC[1][playerid], 0);
	PlayerTextDrawSetProportional(playerid, MDC[1][playerid], 1);
	PlayerTextDrawSetShadow(playerid, MDC[1][playerid], 1);
	PlayerTextDrawSetSelectable(playerid, MDC[1][playerid], 0);

	MDC[2][playerid] = CreatePlayerTextDraw(playerid, 135.000000, 142.000000, " ");
	PlayerTextDrawBackgroundColor(playerid, MDC[2][playerid], 255);
	PlayerTextDrawFont(playerid, MDC[2][playerid], 1);
	PlayerTextDrawLetterSize(playerid, MDC[2][playerid], 0.509999, 1.000000);
	PlayerTextDrawColor(playerid, MDC[2][playerid], 8454143);
	PlayerTextDrawSetOutline(playerid, MDC[2][playerid], 0);
	PlayerTextDrawSetProportional(playerid, MDC[2][playerid], 1);
	PlayerTextDrawSetShadow(playerid, MDC[2][playerid], 1);
	PlayerTextDrawUseBox(playerid, MDC[2][playerid], 1);
	PlayerTextDrawBoxColor(playerid, MDC[2][playerid], 8454143);
	PlayerTextDrawTextSize(playerid, MDC[2][playerid], 491.000000, 1.000000);
	PlayerTextDrawSetSelectable(playerid, MDC[2][playerid], 0);

	MDC[3][playerid] = CreatePlayerTextDraw(playerid, 255.000000, 169.000000, "                                              ");
	PlayerTextDrawBackgroundColor(playerid, MDC[3][playerid], 255);
	PlayerTextDrawFont(playerid, MDC[3][playerid], 1);
	PlayerTextDrawLetterSize(playerid, MDC[3][playerid], 0.890000, 3.599994);
	PlayerTextDrawColor(playerid, MDC[3][playerid], -1);
	PlayerTextDrawSetOutline(playerid, MDC[3][playerid], 0);
	PlayerTextDrawSetProportional(playerid, MDC[3][playerid], 1);
	PlayerTextDrawSetShadow(playerid, MDC[3][playerid], 1);
	PlayerTextDrawUseBox(playerid, MDC[3][playerid], 1);
	PlayerTextDrawBoxColor(playerid, MDC[3][playerid], -206);
	PlayerTextDrawTextSize(playerid, MDC[3][playerid], 374.000000, 1.000000);
	PlayerTextDrawSetSelectable(playerid, MDC[3][playerid], 0);

	MDC[4][playerid] = CreatePlayerTextDraw(playerid, 135.000000, 365.000000, " ");
	PlayerTextDrawBackgroundColor(playerid, MDC[4][playerid], 255);
	PlayerTextDrawFont(playerid, MDC[4][playerid], 1);
	PlayerTextDrawLetterSize(playerid, MDC[4][playerid], 0.509999, 1.000000);
	PlayerTextDrawColor(playerid, MDC[4][playerid], 8454143);
	PlayerTextDrawSetOutline(playerid, MDC[4][playerid], 0);
	PlayerTextDrawSetProportional(playerid, MDC[4][playerid], 1);
	PlayerTextDrawSetShadow(playerid, MDC[4][playerid], 1);
	PlayerTextDrawUseBox(playerid, MDC[4][playerid], 1);
	PlayerTextDrawBoxColor(playerid, MDC[4][playerid], 8454143);
	PlayerTextDrawTextSize(playerid, MDC[4][playerid], 491.000000, 1.000000);
	PlayerTextDrawSetSelectable(playerid, MDC[4][playerid], 0);

	MDC[5][playerid] = CreatePlayerTextDraw(playerid, 261.000000, 171.000000, "ld_otb2:butnc");
	PlayerTextDrawBackgroundColor(playerid, MDC[5][playerid], 0);
	PlayerTextDrawFont(playerid, MDC[5][playerid], 4);
	PlayerTextDrawLetterSize(playerid, MDC[5][playerid], 0.810000, 1.000000);
	PlayerTextDrawColor(playerid, MDC[5][playerid], -1);
	PlayerTextDrawSetOutline(playerid, MDC[5][playerid], 0);
	PlayerTextDrawSetProportional(playerid, MDC[5][playerid], 1);
	PlayerTextDrawSetShadow(playerid, MDC[5][playerid], 1);
	PlayerTextDrawUseBox(playerid, MDC[5][playerid], 1);
	PlayerTextDrawBoxColor(playerid, MDC[5][playerid], 255);
	PlayerTextDrawTextSize(playerid, MDC[5][playerid], 107.000000, 28.000000);
	PlayerTextDrawSetSelectable(playerid, MDC[5][playerid], 1);

	MDC[6][playerid] = CreatePlayerTextDraw(playerid, 261.000000, 203.000000, "ld_otb2:butnc");
	PlayerTextDrawBackgroundColor(playerid, MDC[6][playerid], 0);
	PlayerTextDrawFont(playerid, MDC[6][playerid], 4);
	PlayerTextDrawLetterSize(playerid, MDC[6][playerid], 0.810000, 1.000000);
	PlayerTextDrawColor(playerid, MDC[6][playerid], -1);
	PlayerTextDrawSetOutline(playerid, MDC[6][playerid], 0);
	PlayerTextDrawSetProportional(playerid, MDC[6][playerid], 1);
	PlayerTextDrawSetShadow(playerid, MDC[6][playerid], 1);
	PlayerTextDrawUseBox(playerid, MDC[6][playerid], 1);
	PlayerTextDrawBoxColor(playerid, MDC[6][playerid], 255);
	PlayerTextDrawTextSize(playerid, MDC[6][playerid], 107.000000, 28.000000);
	PlayerTextDrawSetSelectable(playerid, MDC[6][playerid], 1);

	MDC[7][playerid] = CreatePlayerTextDraw(playerid, 261.000000, 236.000000, "ld_otb2:butnc");
	PlayerTextDrawBackgroundColor(playerid, MDC[7][playerid], 0);
	PlayerTextDrawFont(playerid, MDC[7][playerid], 4);
	PlayerTextDrawLetterSize(playerid, MDC[7][playerid], 0.810000, 1.000000);
	PlayerTextDrawColor(playerid, MDC[7][playerid], -1);
	PlayerTextDrawSetOutline(playerid, MDC[7][playerid], 0);
	PlayerTextDrawSetProportional(playerid, MDC[7][playerid], 1);
	PlayerTextDrawSetShadow(playerid, MDC[7][playerid], 1);
	PlayerTextDrawUseBox(playerid, MDC[7][playerid], 1);
	PlayerTextDrawBoxColor(playerid, MDC[7][playerid], 255);
	PlayerTextDrawTextSize(playerid, MDC[7][playerid], 107.000000, 28.000000);
	PlayerTextDrawSetSelectable(playerid, MDC[7][playerid], 1);

	MDC[8][playerid] = CreatePlayerTextDraw(playerid, 261.000000, 271.000000, "ld_otb2:butnc");
	PlayerTextDrawBackgroundColor(playerid, MDC[8][playerid], 0);
	PlayerTextDrawFont(playerid, MDC[8][playerid], 4);
	PlayerTextDrawLetterSize(playerid, MDC[8][playerid], 0.810000, 1.000000);
	PlayerTextDrawColor(playerid, MDC[8][playerid], -1);
	PlayerTextDrawSetOutline(playerid, MDC[8][playerid], 0);
	PlayerTextDrawSetProportional(playerid, MDC[8][playerid], 1);
	PlayerTextDrawSetShadow(playerid, MDC[8][playerid], 1);
	PlayerTextDrawUseBox(playerid, MDC[8][playerid], 1);
	PlayerTextDrawBoxColor(playerid, MDC[8][playerid], 255);
	PlayerTextDrawTextSize(playerid, MDC[8][playerid], 107.000000, 28.000000);
	PlayerTextDrawSetSelectable(playerid, MDC[8][playerid], 1);

	MDC[9][playerid] = CreatePlayerTextDraw(playerid, 287.000000, 174.000000, "PLAYER SEARCH");
	PlayerTextDrawBackgroundColor(playerid, MDC[9][playerid], 255);
	PlayerTextDrawFont(playerid, MDC[9][playerid], 1);
	PlayerTextDrawLetterSize(playerid, MDC[9][playerid], 0.230000, 1.000000);
	PlayerTextDrawColor(playerid, MDC[9][playerid], 8454143);
	PlayerTextDrawSetOutline(playerid, MDC[9][playerid], 1);
	PlayerTextDrawSetProportional(playerid, MDC[9][playerid], 1);
	PlayerTextDrawSetSelectable(playerid, MDC[9][playerid], 0);

	MDC[10][playerid] = CreatePlayerTextDraw(playerid, 286.000000, 206.000000, "VEHICLE SEARCH");
	PlayerTextDrawBackgroundColor(playerid, MDC[10][playerid], 255);
	PlayerTextDrawFont(playerid, MDC[10][playerid], 1);
	PlayerTextDrawLetterSize(playerid, MDC[10][playerid], 0.230000, 1.000000);
	PlayerTextDrawColor(playerid, MDC[10][playerid], 8454143);
	PlayerTextDrawSetOutline(playerid, MDC[10][playerid], 1);
	PlayerTextDrawSetProportional(playerid, MDC[10][playerid], 1);
	PlayerTextDrawSetSelectable(playerid, MDC[10][playerid], 0);

	MDC[11][playerid] = CreatePlayerTextDraw(playerid, 283.000000, 239.000000, "REQUEST BACKUP");
	PlayerTextDrawBackgroundColor(playerid, MDC[11][playerid], 255);
	PlayerTextDrawFont(playerid, MDC[11][playerid], 1);
	PlayerTextDrawLetterSize(playerid, MDC[11][playerid], 0.230000, 1.000000);
	PlayerTextDrawColor(playerid, MDC[11][playerid], 8454143);
	PlayerTextDrawSetOutline(playerid, MDC[11][playerid], 1);
	PlayerTextDrawSetProportional(playerid, MDC[11][playerid], 1);
	PlayerTextDrawSetSelectable(playerid, MDC[11][playerid], 0);

	MDC[12][playerid] = CreatePlayerTextDraw(playerid, 294.000000, 274.000000, "UNIFORMS");
	PlayerTextDrawBackgroundColor(playerid, MDC[12][playerid], 255);
	PlayerTextDrawFont(playerid, MDC[12][playerid], 1);
	PlayerTextDrawLetterSize(playerid, MDC[12][playerid], 0.230000, 1.000000);
	PlayerTextDrawColor(playerid, MDC[12][playerid], 8454143);
	PlayerTextDrawSetOutline(playerid, MDC[12][playerid], 1);
	PlayerTextDrawSetProportional(playerid, MDC[12][playerid], 1);
	PlayerTextDrawSetSelectable(playerid, MDC[12][playerid], 0);

	MDC[13][playerid] = CreatePlayerTextDraw(playerid, 261.000000, 306.000000, "ld_otb2:butnc");
	PlayerTextDrawBackgroundColor(playerid, MDC[13][playerid], 0);
	PlayerTextDrawFont(playerid, MDC[13][playerid], 4);
	PlayerTextDrawLetterSize(playerid, MDC[13][playerid], 0.810000, 1.000000);
	PlayerTextDrawColor(playerid, MDC[13][playerid], -1);
	PlayerTextDrawSetOutline(playerid, MDC[13][playerid], 0);
	PlayerTextDrawSetProportional(playerid, MDC[13][playerid], 1);
	PlayerTextDrawSetShadow(playerid, MDC[13][playerid], 1);
	PlayerTextDrawUseBox(playerid, MDC[13][playerid], 1);
	PlayerTextDrawBoxColor(playerid, MDC[13][playerid], 255);
	PlayerTextDrawTextSize(playerid, MDC[13][playerid], 107.000000, 28.000000);
	PlayerTextDrawSetSelectable(playerid, MDC[13][playerid], 1);

	MDC[14][playerid] = CreatePlayerTextDraw(playerid, 294.000000, 309.000000, "CLOSE MDC");
	PlayerTextDrawBackgroundColor(playerid, MDC[14][playerid], 255);
	PlayerTextDrawFont(playerid, MDC[14][playerid], 1);
	PlayerTextDrawLetterSize(playerid, MDC[14][playerid], 0.230000, 1.000000);
	PlayerTextDrawColor(playerid, MDC[14][playerid], -16776961);
	PlayerTextDrawSetOutline(playerid, MDC[14][playerid], 1);
	PlayerTextDrawSetProportional(playerid, MDC[14][playerid], 1);
	PlayerTextDrawSetSelectable(playerid, MDC[14][playerid], 0);

	MDC[15][playerid] = CreatePlayerTextDraw(playerid, 394.000000, 366.000000, "TECHBYTE DATA");
	PlayerTextDrawBackgroundColor(playerid, MDC[15][playerid], 255);
	PlayerTextDrawFont(playerid, MDC[15][playerid], 2);
	PlayerTextDrawLetterSize(playerid, MDC[15][playerid], 0.280000, 1.699999);
	PlayerTextDrawColor(playerid, MDC[15][playerid], -1);
	PlayerTextDrawSetOutline(playerid, MDC[15][playerid], 0);
	PlayerTextDrawSetProportional(playerid, MDC[15][playerid], 1);
	PlayerTextDrawSetShadow(playerid, MDC[15][playerid], 1);
	PlayerTextDrawSetSelectable(playerid, MDC[15][playerid], 0);
	return 1;
}
stock ShowMDCMenu(playerid)
{
	PlayerTextDrawShow(playerid, MDC[0][playerid]);
	PlayerTextDrawShow(playerid, MDC[1][playerid]);
	PlayerTextDrawShow(playerid, MDC[2][playerid]);
	PlayerTextDrawShow(playerid, MDC[3][playerid]);
	PlayerTextDrawShow(playerid, MDC[4][playerid]);
	PlayerTextDrawShow(playerid, MDC[5][playerid]);
	PlayerTextDrawShow(playerid, MDC[6][playerid]);
	PlayerTextDrawShow(playerid, MDC[7][playerid]);
	PlayerTextDrawShow(playerid, MDC[8][playerid]);
	PlayerTextDrawShow(playerid, MDC[9][playerid]);
	PlayerTextDrawShow(playerid, MDC[10][playerid]);
	PlayerTextDrawShow(playerid, MDC[11][playerid]);
	PlayerTextDrawShow(playerid, MDC[12][playerid]);
	PlayerTextDrawShow(playerid, MDC[13][playerid]);
	PlayerTextDrawShow(playerid, MDC[14][playerid]);
	PlayerTextDrawShow(playerid, MDC[15][playerid]);
	SelectTextDraw(playerid, 0x0080FF);
	MDCShowing[playerid] = 1;
	return 1;
}
stock HideMDCMenu(playerid)
{
	PlayerTextDrawHide(playerid, MDC[0][playerid]);
	PlayerTextDrawHide(playerid, MDC[1][playerid]);
	PlayerTextDrawHide(playerid, MDC[2][playerid]);
	PlayerTextDrawHide(playerid, MDC[3][playerid]);
	PlayerTextDrawHide(playerid, MDC[4][playerid]);
	PlayerTextDrawHide(playerid, MDC[5][playerid]);
	PlayerTextDrawHide(playerid, MDC[6][playerid]);
	PlayerTextDrawHide(playerid, MDC[7][playerid]);
	PlayerTextDrawHide(playerid, MDC[8][playerid]);
	PlayerTextDrawHide(playerid, MDC[9][playerid]);
	PlayerTextDrawHide(playerid, MDC[10][playerid]);
	PlayerTextDrawHide(playerid, MDC[11][playerid]);
	PlayerTextDrawHide(playerid, MDC[12][playerid]);
	PlayerTextDrawHide(playerid, MDC[13][playerid]);
	PlayerTextDrawHide(playerid, MDC[14][playerid]);
	PlayerTextDrawHide(playerid, MDC[15][playerid]);	
	CancelSelectTextDraw(playerid);
	MDCShowing[playerid] = 0;
	return 1;
}
public OnPlayerDisconnect(playerid, reason)
{
	return 1;
}

public OnPlayerSpawn(playerid)
{
	return 1;
}

public OnPlayerDeath(playerid, killerid, reason)
{
	return 1;
}

public OnVehicleSpawn(vehicleid)
{
	return 1;
}

public OnVehicleDeath(vehicleid, killerid)
{
	return 1;
}

public OnPlayerText(playerid, text[])
{
	return 1;
}

public OnPlayerCommandText(playerid, cmdtext[])
{
	if(strcmp("/mdc", cmdtext, true, 10) == 0)
	{
		if(MDCShowing[playerid] == 0)
		{
			ShowMDCMenu(playerid);
		}
		else if(MDCShowing[playerid] == 1)
		{
			HideMDCMenu(playerid);
		}
		return 1;
	}
	return 0;
}

public OnPlayerClickPlayerTextDraw(playerid, PlayerText:playertextid)
{
    if(playertextid == MDC[13][playerid]) // Close MDC
    {
        HideMDCMenu(playerid);
    }
    if(playertextid == MDC[8][playerid]) // Uniforms
    {
    	HideMDCMenu(playerid);
    	ShowPlayerDialog(playerid, DIALOG_MDC_UNIFORMS, DIALOG_STYLE_LIST, "MDC || Uniform Selection", "Uniform 1\nUniform 2\nUniform 3\nUniform 4\nUniform 5\nUniform 6\nUniform 7", "Choose", "Close");
    }
    if(playertextid == MDC[7][playerid])
    {
    	new Float:X, Float:Y, Float:Z;
    	GetPlayerPos(playerid, X, Y, Z);
    	for(new i = 0; i < MAX_PLAYERS; i++)
    	{
    		format(String, sizeof(String), "(POLICE RADIO) %s[%d] has requested backup at his position, GPS marked on your radar.", PlayerName(playerid), playerid);
    		SendClientMessage(i, 0x0080FFFF, String);
    		SetPlayerCheckpoint(i, X, Y, Z, 2.0);
    	}
    	HideMDCMenu(playerid);
    }
    if(playertextid == MDC[5][playerid])
    {
    	ShowPlayerDialog(playerid, DIALOG_MDC_PlayerI, DIALOG_STYLE_INPUT, "MDC || Player Lookup", "=====================================================\nPOLICE MDC\n\nINPUT THE PLAYER NAME TO SEARCH\n\n=====================================================\n", "SEARCH", "");
  		HideMDCMenu(playerid);  
    }
    if(playertextid == MDC[6][playerid])
    {
    	ShowPlayerDialog(playerid, DIALOG_MDC_VehicleI, DIALOG_STYLE_INPUT, "MDC || Vehicle Lookup", "=====================================================\nPOLICE MDC\n\nINPUT THE VEHICLEID TO SEARCH (/dl to get ID)\n\n=====================================================\n", "SEARCH", "");
    	HideMDCMenu(playerid);
    }
    return 1;
}
stock PlayerName(playerid)
{
    new name[MAX_PLAYER_NAME];
    GetPlayerName(playerid,name,sizeof(name));
    for(new i = 0; i < MAX_PLAYER_NAME; i++) {
        if(name[i] == '_') name[i] = ' ';
    }
    return name;
}
public OnPlayerEnterVehicle(playerid, vehicleid, ispassenger)
{
	return 1;
}

public OnPlayerExitVehicle(playerid, vehicleid)
{
	return 1;
}

public OnPlayerStateChange(playerid, newstate, oldstate)
{
	return 1;
}

public OnPlayerEnterCheckpoint(playerid)
{
	DisablePlayerCheckpoint(playerid);
	return 1;
}

public OnPlayerLeaveCheckpoint(playerid)
{
	return 1;
}

public OnPlayerEnterRaceCheckpoint(playerid)
{
	return 1;
}

public OnPlayerLeaveRaceCheckpoint(playerid)
{
	return 1;
}

public OnRconCommand(cmd[])
{
	return 1;
}

public OnPlayerSelectedMenuRow(playerid, row)
{
	return 1;
}

public OnPlayerExitedMenu(playerid)
{
	return 1;
}

public OnPlayerInteriorChange(playerid, newinteriorid, oldinteriorid)
{
	return 1;
}

public OnPlayerKeyStateChange(playerid, newkeys, oldkeys)
{
	return 1;
}

public OnRconLoginAttempt(ip[], password[], success)
{
	return 1;
}

public OnPlayerUpdate(playerid)
{
	return 1;
}
new dialog_message[1500];
new Message[1000];
public OnDialogResponse(playerid, dialogid, response, listitem, inputtext[])
{
	if(dialogid == DIALOG_MDC_PlayerI)
	{
		new pid = GetPlayerIdFromName(inputtext);
		if(pid == INVALID_PLAYER_ID)
		{
			SendClientMessage(playerid, 0xFFFFFFFF, "Invalid player.");
			return 1;
		}

        format(dialog_message, sizeof(dialog_message), ""); // Reset the string
        new Float:health;
    	GetPlayerHealth(pid,health);
        // DIALOG RESULT MESSAGE
        format(Message, sizeof(Message), "{FFFFFF}LSPD || MOBILE DATA COMPUTER\n");
        strcat(dialog_message, Message);
        format(Message, sizeof(Message), "{0080FF}===========================================================\n");
        strcat(dialog_message, Message);
        format(Message, sizeof(Message), "{0080FF}Full Name {FFFFFF}- %s [%d]\n", PlayerName(pid), pid);
        strcat(dialog_message, Message);
        format(Message, sizeof(Message), "{0080FF}Skin {FFFFFF}- %d\n", GetPlayerSkin(pid));
        strcat(dialog_message, Message);
        format(Message, sizeof(Message), "{0080FF}Health{FFFFFF}- %f\n", health);
        strcat(dialog_message, Message);
        format(Message, sizeof(Message), "{0080FF}Cash {FFFFFF}- %d\n", GetPlayerMoney(pid));
        strcat(dialog_message, Message);
        format(Message, sizeof(Message), "{0080FF}===========================================================\n");
        strcat(dialog_message, Message);
        ShowPlayerDialog(playerid, DIALOG_MDC_PlayerR, DIALOG_STYLE_MSGBOX, "MDC || Player Lookup", dialog_message, "Close", "");
	}
	if(dialogid == DIALOG_MDC_PlayerR)
	{
		if(!response)
		{
			ShowMDCMenu(playerid);
		}
		ShowMDCMenu(playerid);
	}
	if(dialogid == DIALOG_MDC_VehicleR)
	{
		if(!response)
		{
			ShowMDCMenu(playerid);
		}
		ShowMDCMenu(playerid);
	}
	if(dialogid == DIALOG_MDC_VehicleI)
	{
        format(dialog_message, sizeof(dialog_message), ""); // Reset the string
        new panels,doors,lights,tires;
		GetVehicleDamageStatus(strval(inputtext),panels,doors,lights,tires);
        // DIALOG RESULT MESSAGE
        format(Message, sizeof(Message), "{FFFFFF}LSPD || MOBILE DATA COMPUTER\n");
        strcat(dialog_message, Message);
        format(Message, sizeof(Message), "{0080FF}===========================================================\n");
        strcat(dialog_message, Message);
        format(Message, sizeof(Message), "{0080FF}Vehicle Type {FFFFFF}- %s\n", GetVehicleName(strval(inputtext)));
        strcat(dialog_message, Message);
        format(Message, sizeof(Message), "{0080FF}Vehicle Damage {FFFFFF}- [Panels] : %d - [Doors] : %d - [Lights] : %d - [Tires] : %d\n", panels, doors, lights, tires);
        strcat(dialog_message, Message);
        format(Message, sizeof(Message), "{0080FF}===========================================================\n");
        strcat(dialog_message, Message);
        ShowPlayerDialog(playerid, DIALOG_MDC_VehicleR, DIALOG_STYLE_MSGBOX, "MDC || Vehicle Lookup", dialog_message, "Close", "");
	}
	if(dialogid == DIALOG_MDC_UNIFORMS)
	{
		if(!response)
		{
			return 1;
		}
		else
		{
			//The player has pressed "Choose".
			switch(listitem)
			{
				case 0:
				{
					//Selected Item: "Uniform 1"
					SetPlayerSkin(playerid, 280);
				}
				case 1:
				{
					//Selected Item: "Uniform 2"
					SetPlayerSkin(playerid, 281);
				}
				case 2:
				{
					//Selected Item: "Uniform 3"
					SetPlayerSkin(playerid, 282);
				}
				case 3:
				{
					//Selected Item: "Uniform 4"
					SetPlayerSkin(playerid, 283);
				}
				case 4:
				{
					//Selected Item: "Uniform 5"
					SetPlayerSkin(playerid, 288);
				}
				case 5:
				{
					//Selected Item: "Uniform 6"
					SetPlayerSkin(playerid, 284);
				}
				case 6:
				{
					//Selected Item: "Uniform 7"
					SetPlayerSkin(playerid, 285);
				}
			}
		}
	}
	return 1;
}
stock GetVehicleName(vehicleid)
{
    format(String,sizeof(String),"%s",VehicleNames[GetVehicleModel(vehicleid) - 400]);
    return String;
}
stock GetPlayerIdFromName(playername[])
{
  for(new i = 0; i <= MAX_PLAYERS; i++)
  {
    if(IsPlayerConnected(i))
    {
      new playername2[MAX_PLAYER_NAME];
      GetPlayerName(i, playername2, sizeof(playername2));
      if(strcmp(playername2, playername, true, strlen(playername)) == 0)
      {
        return i;
      }
    }
  }
  return INVALID_PLAYER_ID;
}